/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.lighting;

import com.badlogic.gdx.math.Vector2;
import java.util.Comparator;

public class ClockwisePointComparator
implements Comparator<Vector2> {
    @Override
    public int compare(Vector2 a, Vector2 b) {
        if (a.x >= 0.0f && b.x < 0.0f) {
            return -1;
        }
        if (a.x < 0.0f && b.x >= 0.0f) {
            return 1;
        }
        if (a.x == 0.0f && b.x == 0.0f) {
            if (a.y >= 0.0f || b.y >= 0.0f) {
                if (a.y > b.y) {
                    return -1;
                }
                return 1;
            }
            if (b.y > a.y) {
                return -1;
            }
            return 1;
        }
        float det = a.x * b.y - b.x * a.y;
        if (det < 0.0f) {
            return -1;
        }
        if (det > 0.0f) {
            return 1;
        }
        float d1 = a.x * a.x + a.y * a.y;
        float d2 = b.x * b.x + b.y * b.y;
        if (d1 > d2) {
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        return 0;
    }
}

